<?php
$settings                   = $args['settings'];
$user_info                  = get_userdata( get_current_user_id() );
$username                   = $user_info->user_login;
$admin_email                = get_option('admin_email');
$admin_user                 = get_user_by('email', $admin_email);
$param                      = [];
$param['user_name']         = $username;
$param['admin_name']        = $admin_user->user_login;
$thanks_txt                 = apply_filters( 'codesigner_email_replace_placeholders',$settings['thanks_txt_reset'], $param );
$order_sub_text             = apply_filters( 'codesigner_email_replace_placeholders',$settings['order_sub_txt_reset'], $param );
$order_txt                  = apply_filters( 'codesigner_email_replace_placeholders',$settings['order_heading_txt_reset'], $param );
$user_msg                   = apply_filters( 'codesigner_email_replace_placeholders',$settings['user_section_user_head_msg_text'], $param );
$link_text                  = apply_filters( 'codesigner_email_replace_placeholders',$settings['link_text_reset'], $param );

?>
<div class='codesigner-email-wrapper'>
    <table class="codesigner-email-template">
        <tbody class="cd-email-bg" id="cd-customer-reset-password">
            <tr>
                <td class="cd-no-border cd-deafult-bg"></td>
                <td class="cd-email-center cd-no-border">
                    <div class="codesigner-email-header">
                        <h3 class="codesigner-order-id"><?php printf( "%1s", $order_txt )?></h3>
                    </div>
                    <div class='cd-email-body-wrapper'>
                        <div class="codesigner-reset-password-message">
                            <p><?php echo wp_kses_post( $order_sub_text ); ?></p>
                        </div>
                        <div class="co-desginer-user-name-email">
                            <p class="cd-usernmae"> <?php printf( "%1s : %2s", __( 'Username', 'codesigner-pro' ), $username ); ?> </p>
                            <p class="cd-ignore-message"> <?php _e( $user_msg , 'codesigner-pro' ); ?> </p>
                            <p class="cd-reset-password"> <?php printf( "<a href='%1s'>%2s</a>", '%%reset_password%%' , $link_text );?> </p>
                        </div> 
                        <div class="cd-before-footer-message">
                            <p><?php echo wp_kses_post( $thanks_txt ); ?> </p>
                        </div>
                    </div>
                </td>
                <td class="cd-no-border cd-deafult-bg"></td>
            </tr>
        </tbody>
    </table>
</div>
<?php 